document.addEventListener('DOMContentLoaded', function () {
    const videoList = document.getElementById('tvft-video-list');
    const addVideoButton = document.getElementById('add-video-button');

    // Add a new video input field
    function addVideoInput(index) {
        const newVideoInput = document.createElement('div');
        newVideoInput.className = 'video-input-wrapper';
        newVideoInput.innerHTML = `
            <label for="tvft_free_trial_video_url_${index}">Free Course Video URL ${index + 1}:</label>
            <input type="text" id="tvft_free_trial_video_url_${index}" name="tvft_free_trial_video_urls[]" value="" style="width: 100%;" placeholder="https://www.youtube.com/watch?v=your_video_id">
            <label for="tvft_free_trial_video_title_${index}">Video Title ${index + 1}:</label>
            <input type="text" id="tvft_free_trial_video_title_${index}" name="tvft_free_trial_video_titles[]" value="" style="width: 100%;" placeholder="Enter video title here">
            <button type="button" class="remove-video-button">Remove</button>
            <br><br>
        `;

        // Add event listener to the remove button
        newVideoInput.querySelector('.remove-video-button').addEventListener('click', function () {
            newVideoInput.remove();
        });

        videoList.appendChild(newVideoInput);
    }

    // Add event listener for 'Add Another Video' button
    if (addVideoButton) {
        addVideoButton.addEventListener('click', function () {
            const index = videoList.children.length;
            addVideoInput(index);
        });
    }

    // Initial setup for pre-existing videos
    const preExistingRemoveButtons = document.querySelectorAll('.remove-video-button');
    preExistingRemoveButtons.forEach(button => {
        button.addEventListener('click', function () {
            this.parentElement.remove();
        });
    });
});
